/** OTLN_Strs.c
	
	Note the line "STR_TABLE_EXTERN(OTLN);" in OTLN.h so all code that
	needs to ask for a string has access to this table.
**/

#include "OTLNp.h"

#ifdef	USING_U
	#include <STR.h>
#else
	#define STR_TABLE_START(_foo)	\
		ErrorString		g_o_errorStrings[] = {

	#define	STR_ENTRY(_foo, _bar)	_bar,

	#define STR_TABLE_END(_foo)	"last string" };
#endif

STR_TABLE_START(OTLN)
	STR_ENTRY(00, "outline")
	STR_ENTRY(01, "topic")
	STR_ENTRY(02, "geneva")
	STR_ENTRY(03, "Root")
	STR_ENTRY(04, "can't add aunt to root topic.")
	STR_ENTRY(05, "can't remove topic from empty outline.")

	STR_ENTRY(06, "can't iterate over %s.")
	STR_ENTRY(07, "outline without iterate function")
	STR_ENTRY(08, "outline without outline reference.")
	STR_ENTRY(09, "family without family reference.")
	STR_ENTRY(10, "children without child reference.")
	STR_ENTRY(11, "children if there aren't any children.")
	
	STR_ENTRY(12, "can't find or allocate twirly arrow number %d.")

	STR_ENTRY(13, "magic spell failed on an outline.")
	STR_ENTRY(14, "magic spell failed on a topic.")
	
	STR_ENTRY(15, "magic outline handle or master pointer is null.")
	STR_ENTRY(16, "magic topic handle or master pointer is null.")
	
	STR_ENTRY(17, "save/restore topic info structure")

	STR_ENTRY(18, "topic has no owning outline.")

	STR_ENTRY(19, "out of memory while duplicating an outline.")
	STR_ENTRY(20, "out of memory while creating an outline topic.")
	STR_ENTRY(21, "out of memory while duplicating an outline topic.")

	STR_ENTRY(22, "bad insertion index for adding topic to outline.")
	
STR_TABLE_END(OTLN)
